/* Copyright (c) 2008, Oracle. All rights reserved. */

import java.io.*;
import java.sql.*;
import oracle.sql.*;

public class LASHeader{
	// all integers are supposed to be unsigned
	byte[] fileSignature=new byte[4];
	byte[] reserved=new byte[4];
	byte[] guidData1=new byte[4];
	byte[] guidData2=new byte[2];
	byte[] guidData3=new byte[2];
	byte[] guidData4=new byte[8];
	byte[] versionMajor=new byte[1];
	byte[] versionMinor=new byte[1];
	byte[] systemIdentifier=new byte[32];
	byte[] generatingSoftware=new byte[32];
	byte[] flightJulianDate=new byte[2];
	byte[] year=new byte[2];
	byte[] headerSize=new byte[2];
	byte[] offsetToData=new byte[4];
	byte[] numberOfVariableLengthRecords=new byte[4];
	byte[] pointDataFormatID=new byte[1];
	byte[] pointDataRecordLength=new byte[2];
	byte[] numberOfPointRecords=new byte[4];
	byte[] numberOfPointsByReturn1=new byte[4];
	byte[] numberOfPointsByReturn2=new byte[4];
	byte[] numberOfPointsByReturn3=new byte[4];
	byte[] numberOfPointsByReturn4=new byte[4];
	byte[] numberOfPointsByReturn5=new byte[4];
	byte[] xScaleFactor=new byte[8];
	byte[] yScaleFactor=new byte[8];
	byte[] zScaleFactor=new byte[8];
	byte[] xOffset=new byte[8];
	byte[] yOffset=new byte[8];
	byte[] zOffset=new byte[8];
	byte[] maxX=new byte[8];
	byte[] minX=new byte[8];
	byte[] maxY=new byte[8];
	byte[] minY=new byte[8];
	byte[] maxZ=new byte[8];
	byte[] minZ=new byte[8];
	byte[] extraData;


	public LASHeader(){
	}

	public void parse(InputStream inputStream){
		try{
			inputStream.read(fileSignature);
			inputStream.read(reserved);
			inputStream.read(guidData1);
			inputStream.read(guidData2);
			inputStream.read(guidData3);
			inputStream.read(guidData4);
			inputStream.read(versionMajor);
			inputStream.read(versionMinor);
			inputStream.read(systemIdentifier);
			inputStream.read(generatingSoftware);
			inputStream.read(flightJulianDate);
			inputStream.read(year);
			inputStream.read(headerSize);
			inputStream.read(offsetToData);
			inputStream.read(numberOfVariableLengthRecords);
			inputStream.read(pointDataFormatID);
			inputStream.read(pointDataRecordLength);
			inputStream.read(numberOfPointRecords);
			inputStream.read(numberOfPointsByReturn1);
			inputStream.read(numberOfPointsByReturn2);
			inputStream.read(numberOfPointsByReturn3);
			inputStream.read(numberOfPointsByReturn4);
			inputStream.read(numberOfPointsByReturn5);
			inputStream.read(xScaleFactor);
			inputStream.read(yScaleFactor);
			inputStream.read(zScaleFactor);
			inputStream.read(xOffset);
			inputStream.read(yOffset);
			inputStream.read(zOffset);
			inputStream.read(maxX);
			inputStream.read(minX);
			inputStream.read(maxY);
			inputStream.read(minY);
			inputStream.read(maxZ);
			inputStream.read(minZ);
			int bytesRemaining=littleEndianArray2ToInt(headerSize)-227;
			extraData=new byte[bytesRemaining];
			inputStream.read(extraData);
		} catch(IOException exception){
			exception.printStackTrace();
		}
	}

	public void write(OutputStream outputStream){
		try{
			outputStream.write(fileSignature);
			outputStream.write(reserved);
			outputStream.write(guidData1);
			outputStream.write(guidData2);
			outputStream.write(guidData3);
			outputStream.write(guidData4);
			outputStream.write(versionMajor);
			outputStream.write(versionMinor);
			outputStream.write(systemIdentifier);
			outputStream.write(generatingSoftware);
			outputStream.write(flightJulianDate);
			outputStream.write(year);
			outputStream.write(headerSize);
			outputStream.write(offsetToData);
			outputStream.write(numberOfVariableLengthRecords);
			outputStream.write(pointDataFormatID);
			outputStream.write(pointDataRecordLength);
			outputStream.write(numberOfPointRecords);
			outputStream.write(numberOfPointsByReturn1);
			outputStream.write(numberOfPointsByReturn2);
			outputStream.write(numberOfPointsByReturn3);
			outputStream.write(numberOfPointsByReturn4);
			outputStream.write(numberOfPointsByReturn5);
			outputStream.write(xScaleFactor);
			outputStream.write(yScaleFactor);
			outputStream.write(zScaleFactor);
			outputStream.write(xOffset);
			outputStream.write(yOffset);
			outputStream.write(zOffset);
			outputStream.write(maxX);
			outputStream.write(minX);
			outputStream.write(maxY);
			outputStream.write(minY);
			outputStream.write(maxZ);
			outputStream.write(minZ);
			if(extraData != null){
				outputStream.write(extraData);
			}
		}catch(IOException exception){
			exception.printStackTrace();
		}
	}

	public String arrayToString(byte[] array){
		String string=new String(array);
		int breakPoint=string.length();
		for(int a=0;a<string.length();a++){
			if(string.charAt(a)<32 || string.charAt(a)>126){
				breakPoint=a;
				break;
			}
		}
		string=string.substring(0,breakPoint);
		return string;
	}

	public byte[] stringToArray(int arraySize,String string){
		byte[] array=new byte[arraySize];
		if(string==null){
			string=new String();
		}
		for(int a=0;a<string.length();a++){
			array[a]=(byte)string.charAt(a);
		}
		for(int a=string.length();a<arraySize;a++){
			array[a]=(char)0x0;
		}
		return array;
	}


	public double littleEndianArray8ToDouble(byte[] array){
		long longBits=(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
		return java.lang.Double.longBitsToDouble(longBits);
	}

	public byte[] doubleToLittleEndianArray8(Double number){
		byte[] array=new byte[8];
		long l = Double.doubleToLongBits(number);
		array[0]=(byte)((l>>0)&0xFFL);
		array[1]=(byte)((l>>8)&0xFFL);
		array[2]=(byte)((l>>16)&0xFFL);
		array[3]=(byte)((l>>24)&0xFFL);
		array[4]=(byte)((l>>32)&0xFFL);
		array[5]=(byte)((l>>40)&0xFFL);
		array[6]=(byte)((l>>48)&0xFFL);
		array[7]=(byte)((l>>56)&0xFFL);

		return array;
	}


	public double littleEndianArray4ToDouble(byte[] array){
		long longBits=(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24);
		return java.lang.Double.longBitsToDouble(longBits);
	}

	public byte[] doubleToLittleEndianArray4(Double number){
		byte[] array=new byte[4];
		long l = Double.doubleToLongBits(number);
		array[0]=(byte)((l>>0)&0xFFL);
		array[1]=(byte)((l>>8)&0xFFL);
		array[2]=(byte)((l>>16)&0xFFL);
		array[3]=(byte)((l>>24)&0xFFL);

		return array;
	}


	public long littleEndianArray8ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
	}

	public byte[] longToLittleEndianArray8(long number){
		byte[] array=new byte[8];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);
		array[4]=(byte)((number>>32)&0xFFL);
		array[5]=(byte)((number>>40)&0xFFL);
		array[6]=(byte)((number>>48)&0xFFL);
		array[7]=(byte)((number>>56)&0xFFL);

		return array;
	}


	public long littleEndianArray4ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24);
	}

	public byte[] longToLittleEndianArray4(long number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}


	public int littleEndianArray4ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8)|(((int)array[2]&0xFF)<<16)|(((int)array[3]&0xFF)<<24);
	}

	public byte[] intToLittleEndianArray4(int number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}


	public int littleEndianArray2ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8);
	}

	public byte[] intToLittleEndianArray2(int number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;
	}


	public int littleEndianArray1ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0);
	}

	public byte[] intToLittleEndianArray1(int number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}


	public short littleEndianArray2ToShort(byte[] array){
		return(short)(((((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8))&0xFFFF);
	}

	public byte[] shortToLittleEndianArray2(short number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;
	}


	public byte littleEndianArray1ToByte(byte[] array){
		return array[0];
	}

	public byte[] byteToLittleEndianArray1(byte number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}

	public String getFileSignature(){
		return arrayToString(fileSignature);
	}

	public void putFileSignature(String fileSignature){
		this.fileSignature=stringToArray(this.fileSignature.length,fileSignature);
	}

	public long getReserved(){
		return littleEndianArray4ToLong(reserved);
	}

	public void putReserved(long reserved){
		this.reserved=longToLittleEndianArray4(reserved);
	}

	public long getGuidData1(){
		return littleEndianArray4ToLong(guidData1);
	}

	public void putGuidData1(long guidData1){
		this.guidData1=longToLittleEndianArray4(guidData1);
	}

	public int getGuidData2(){
		return littleEndianArray2ToInt(guidData2);
	}

	public void putGuidData2(int guidData2){
		this.guidData2=intToLittleEndianArray2(guidData2);
	}

	public int getGuidData3(){
		return littleEndianArray2ToInt(guidData3);
	}

	public void putGuidData3(int guidData3){
		this.guidData3=intToLittleEndianArray2(guidData3);
	}

	public String getGuidData4(){
		return arrayToString(guidData4);
	}

	public void putGuidData4(String guidData4){
		this.guidData4=stringToArray(this.guidData4.length,guidData4);
	}

	public int getVersionMajor(){
		return littleEndianArray1ToInt(versionMajor);
	}

	public void putVersionMajor(int versionMajor){
		this.versionMajor=intToLittleEndianArray1(versionMajor);
	}

	public int getVersionMinor(){
		return littleEndianArray1ToInt(versionMinor);
	}

	public void putVersionMinor(int versionMinor){
		this.versionMinor=intToLittleEndianArray1(versionMinor);
	}

	public String getSystemIdentifier(){
		return arrayToString(systemIdentifier);
	}

	public void putSystemIdentifier(String systemIdentifier){
		this.systemIdentifier=stringToArray(this.systemIdentifier.length,systemIdentifier);
	}

	public String getGeneratingSoftware(){
		return arrayToString(generatingSoftware);
	}

	public void putGeneratingSoftware(String generatingSoftware){
		this.generatingSoftware=stringToArray(this.generatingSoftware.length,generatingSoftware);
	}

	public int getFlightJulianDate(){
		return littleEndianArray2ToInt(flightJulianDate);
	}

	public void putFlightJulianDate(int flightJulianDate){
		this.flightJulianDate=intToLittleEndianArray2(flightJulianDate);
	}

	public int getYear(){
		return littleEndianArray2ToInt(year);
	}

	public void putYear(int year){
		this.year=intToLittleEndianArray2(year);
	}

	public int getHeaderSize(){
		return littleEndianArray2ToInt(headerSize);
	}

	public void putHeaderSize(int headerSize){
		this.headerSize=intToLittleEndianArray2(headerSize);
	}

	public long getOffsetToData(){
		return littleEndianArray4ToLong(offsetToData);
	}

	public void putOffsetToData(long offsetToDate){
		this.offsetToData=longToLittleEndianArray4(offsetToDate);
	}

	public long getNumberOfVariableLengthRecords(){
		return littleEndianArray4ToLong(numberOfVariableLengthRecords);
	}

	public void putNumberOfVariableLengthRecords(long numberOfVariableLengthRecords){
		this.numberOfVariableLengthRecords=longToLittleEndianArray4(numberOfVariableLengthRecords);
	}

	public int getPointDataFormatID(){
		return littleEndianArray1ToInt(pointDataFormatID);
	}

	public void putPointDataFormatID(int pointDataFormatID){
		this.pointDataFormatID=intToLittleEndianArray1(pointDataFormatID);
	}

	public int getPointDataRecordLength(){
		return littleEndianArray2ToInt(pointDataRecordLength);
	}

	public void putPointDataRecordLength(int pointDataRecordLength){
		this.pointDataRecordLength=intToLittleEndianArray2(pointDataRecordLength);
	}

	public long getNumberOfPointRecords(){
		return littleEndianArray4ToLong(numberOfPointRecords);
	}

	public void putNumberOfPointRecords(long numberOfPointRecords){
		this.numberOfPointRecords=longToLittleEndianArray4(numberOfPointRecords);
	}

	public long getNumberOfPointsByReturn1(){
		return littleEndianArray4ToLong(numberOfPointsByReturn1);
	}

	public void putNumberOfPointsByReturn1(long numberOfPointsByReturn1){
		this.numberOfPointsByReturn1=longToLittleEndianArray4(numberOfPointsByReturn1);
	}

	public long getNumberOfPointsByReturn2(){
		return littleEndianArray4ToLong(numberOfPointsByReturn2);
	}

	public void putNumberOfPointsByReturn2(long numberOfPointsByReturn2){
		this.numberOfPointsByReturn2=longToLittleEndianArray4(numberOfPointsByReturn2);
	}

	public long getNumberOfPointsByReturn3(){
		return littleEndianArray4ToLong(numberOfPointsByReturn3);
	}

	public void putNumberOfPointsByReturn3(long numberOfPointsByReturn3){
		this.numberOfPointsByReturn3=longToLittleEndianArray4(numberOfPointsByReturn3);
	}

	public long getNumberOfPointsByReturn4(){
		return littleEndianArray4ToLong(numberOfPointsByReturn4);
	}

	public void putNumberOfPointsByReturn4(long numberOfPointsByReturn4){
			this.numberOfPointsByReturn4=longToLittleEndianArray4(numberOfPointsByReturn4);
	}

	public long getNumberOfPointsByReturn5(){
		return littleEndianArray4ToLong(numberOfPointsByReturn5);
	}

	public void putNumberOfPointsByReturn5(long numberOfPointsByReturn5){
		this.numberOfPointsByReturn5=longToLittleEndianArray4(numberOfPointsByReturn5);
	}

	public double getXScaleFactor(){
		return littleEndianArray8ToDouble(xScaleFactor);
	}

	public void putXScaleFactor(double xScaleFactor){
		this.xScaleFactor=doubleToLittleEndianArray8(xScaleFactor);
	}

	public double getYScaleFactor(){
		return littleEndianArray8ToDouble(yScaleFactor);
	}

	public void putYScaleFactor(double yScaleFactor){
		this.yScaleFactor=doubleToLittleEndianArray8(yScaleFactor);
	}

	public double getZScaleFactor(){
		return littleEndianArray8ToDouble(zScaleFactor);
	}

	public void putZScaleFactor(double zScaleFactor){
		this.zScaleFactor=doubleToLittleEndianArray8(zScaleFactor);
	}

	public double getXOffset(){
		return littleEndianArray8ToDouble(xOffset);
	}

	public void putXOffset(double xOffset){
		this.xOffset=doubleToLittleEndianArray8(xOffset);
	}

	public double getYOffset(){
		return littleEndianArray8ToDouble(yOffset);
	}

	public void putYOffset(double yOffset){
		this.yOffset=doubleToLittleEndianArray8(yOffset);
	}

	public double getZOffset(){
		return littleEndianArray8ToDouble(zOffset);
	}

	public void putZOffset(double zOffset){
		this.zOffset=doubleToLittleEndianArray8(zOffset);
	}

	public double getMaxX(){
		return littleEndianArray8ToDouble(maxX);
	}

	public void putMaxX(double maxX){
		this.maxX=doubleToLittleEndianArray8(maxX);
	}

	public double getMinX(){
		return littleEndianArray8ToDouble(minX);
	}

	public void putMinX(double minX){
		this.minX=doubleToLittleEndianArray8(minX);
	}

	public double getMaxY(){
		return littleEndianArray8ToDouble(maxY);
	}

	public void putMaxY(double maxY){
		this.maxY=doubleToLittleEndianArray8(maxY);
	}

	public double getMinY(){
		return littleEndianArray8ToDouble(minY);
	}

	public void putMinY(double minY){
		this.minY=doubleToLittleEndianArray8(minY);
	}

	public double getMaxZ(){
		return littleEndianArray8ToDouble(maxZ);
	}


	public void putMaxZ(double maxZ){
		this.maxZ=doubleToLittleEndianArray8(maxZ);
	}

	public double getMinZ(){
		return littleEndianArray8ToDouble(minZ);
	}

	public void setMinZ(double minZ){
		this.minZ=doubleToLittleEndianArray8(minZ);
	}

	public byte[] getExtraData(){
		return extraData;
	}

	public void putExtraData(byte[] extraData){
		this.extraData=extraData;
	}


	public int getRecordLength(){
		int recordLength= fileSignature.length+
			  reserved.length+
			  guidData1.length+
			  guidData2.length+
			  guidData3.length+
			  guidData4.length+
			  versionMajor.length+
			  versionMinor.length+
			  systemIdentifier.length+
			  generatingSoftware.length+
			  flightJulianDate.length+
			  year.length+
			  headerSize.length+
			  offsetToData.length+
			  numberOfVariableLengthRecords.length+
			  pointDataFormatID.length+
			  pointDataRecordLength.length+
			  numberOfPointRecords.length+
			  numberOfPointsByReturn1.length+
			  numberOfPointsByReturn2.length+
			  numberOfPointsByReturn3.length+
			  numberOfPointsByReturn4.length+
			  numberOfPointsByReturn5.length+
			  xScaleFactor.length+
			  yScaleFactor.length+
			  zScaleFactor.length+
			  xOffset.length+
			  yOffset.length+
			  zOffset.length+
			  maxX.length+
			  minX.length+
			  maxY.length+
			  minY.length+
			  maxZ.length+
			  minZ.length;
		if (extraData != null){
		  recordLength+=extraData.length;
		}
		return recordLength;
	}



	public void print(){
		System.out.println("FileSignature "+getFileSignature());
		System.out.println("Reserved "+getReserved());
		System.out.println("GuidData1 "+getGuidData1());
		System.out.println("GuidData2 "+getGuidData2());
		System.out.println("GuidData3 "+getGuidData3());
		System.out.println("GuidData4 "+getGuidData4());
		System.out.println("VersionMajor "+getVersionMajor());
		System.out.println("VersionMinor "+getVersionMinor());
		System.out.println("SystemIdentifier "+getSystemIdentifier());
		System.out.println("GeneratingSoftware "+getGeneratingSoftware());
		System.out.println("FlightJulianDate "+getFlightJulianDate());
		System.out.println("Year "+getYear());
		System.out.println("HeaderSize "+getHeaderSize());
		System.out.println("OffsetToData "+getOffsetToData());
		System.out.println("NumberOfVariableLengthRecords "+getNumberOfVariableLengthRecords());
		System.out.println("PointDataFormatID "+getPointDataFormatID());
		System.out.println("PointDataRecordLength "+getPointDataRecordLength());
		System.out.println("NumberOfPointRecords "+getNumberOfPointRecords());
		System.out.println("NumberOfPointsByReturn1 "+getNumberOfPointsByReturn1());
		System.out.println("NumberOfPointsByReturn2 "+getNumberOfPointsByReturn2());
		System.out.println("NumberOfPointsByReturn3 "+getNumberOfPointsByReturn3());
		System.out.println("NumberOfPointsByReturn4 "+getNumberOfPointsByReturn4());
		System.out.println("NumberOfPointsByReturn5 "+getNumberOfPointsByReturn5());
		System.out.println("XScaleFactor "+getXScaleFactor());
		System.out.println("YScaleFactor "+getYScaleFactor());
		System.out.println("ZScaleFactor "+getZScaleFactor());
		System.out.println("XOffset "+getXOffset());
		System.out.println("YOffset "+getYOffset());
		System.out.println("ZOffset "+getZOffset());
		System.out.println("MaxX "+getMaxX());
		System.out.println("MinX "+getMinX());
		System.out.println("MaxY "+getMaxY());
		System.out.println("MinY "+getMinY());
		System.out.println("MaxZ "+getMaxZ());
		System.out.println("MinZ "+getMinZ());
//		System.out.println("extra data: "+arrayToBits(extraData));
	}

	public String getHeaderString(){
		String headerString=new String();
		headerString+="FileSignature "+getFileSignature()+"\n";
		headerString+="Reserved "+getReserved()+"\n";
		headerString+="GuidData1 "+getGuidData1()+"\n";
		headerString+="GuidData2 "+getGuidData2()+"\n";
		headerString+="GuidData3 "+getGuidData3()+"\n";
		headerString+="GuidData4 "+getGuidData4()+"\n";
		headerString+="VersionMajor "+getVersionMajor()+"\n";
		headerString+="VersionMinor "+getVersionMinor()+"\n";
		headerString+="SystemIdentifier "+getSystemIdentifier()+"\n";
		headerString+="GeneratingSoftware "+getGeneratingSoftware()+"\n";
		headerString+="FlightJulianDate "+getFlightJulianDate()+"\n";
		headerString+="Year "+getYear()+"\n";
		headerString+="HeaderSize "+getHeaderSize()+"\n";
		headerString+="OffsetToData "+getOffsetToData()+"\n";
		headerString+="NumberOfVariableLengthRecords "+getNumberOfVariableLengthRecords()+"\n";
		headerString+="PointDataFormatID "+getPointDataFormatID()+"\n";
		headerString+="PointDataRecordLength "+getPointDataRecordLength()+"\n";
		headerString+="NumberOfPointRecords "+getNumberOfPointRecords()+"\n";
		headerString+="NumberOfPointsByReturn1 "+getNumberOfPointsByReturn1()+"\n";
		headerString+="NumberOfPointsByReturn2 "+getNumberOfPointsByReturn2()+"\n";
		headerString+="NumberOfPointsByReturn3 "+getNumberOfPointsByReturn3()+"\n";
		headerString+="NumberOfPointsByReturn4 "+getNumberOfPointsByReturn4()+"\n";
		headerString+="NumberOfPointsByReturn5 "+getNumberOfPointsByReturn5()+"\n";
		headerString+="XScaleFactor "+getXScaleFactor()+"\n";
		headerString+="YScaleFactor "+getYScaleFactor()+"\n";
		headerString+="ZScaleFactor "+getZScaleFactor()+"\n";
		headerString+="XOffset "+getXOffset()+"\n";
		headerString+="YOffset "+getYOffset()+"\n";
		headerString+="ZOffset "+getZOffset()+"\n";
		headerString+="MaxX "+getMaxX()+"\n";
		headerString+="MinX "+getMinX()+"\n";
		headerString+="MaxY "+getMaxY()+"\n";
		headerString+="MinY "+getMinY()+"\n";
		headerString+="MaxZ "+getMaxZ()+"\n";
		headerString+="MinZ "+getMinZ()+"\n";
//		System.out.println("extra data: "+arrayToBits(extraData));
		return headerString;
	}

	public String arrayToBits(byte[] bytes){
		String string=new String();
		for(int a=0;a<bytes.length;a++){
			for(int b=7,c=1;b>-1;b--,c++){
				string+=(bytes[a]>>>b)&0x01;
				if(c==4){
					string+=" ";
				}
				if(c==8){
					string+=" ";
					c=0;
				}
			}
		}
		return string;
	}

	/*
	 public byte[] byteArray(byte source[],int count){
	  byte array[]=new byte[count];
	  for(int a=0;a<count;a++){
	   array[a]=source[packetPointer+a];
	  }
	  packetPointer+=count;
	  return array;
	 }
	 */

	public static void main(String[] args){
		LASHeader lasheader=new LASHeader();

		lasheader.putFileSignature("xyz");
		System.out.println("|"+lasheader.getFileSignature()+"|");
		lasheader.putFlightJulianDate(12345);
		System.out.println(lasheader.getFlightJulianDate());
		lasheader.putReserved(22222);
		System.out.println(lasheader.getReserved());
		lasheader.putGuidData1(111111);
		System.out.println(lasheader.getGuidData1());
		lasheader.putGuidData2(33);
		System.out.println(lasheader.getGuidData2());
		lasheader.putGuidData4("test GUI");
		System.out.println(lasheader.getGuidData4());
		lasheader.putVersionMajor(1);
		System.out.println(lasheader.getVersionMajor());
		lasheader.putXScaleFactor(123.999);
		System.out.println(lasheader.getXScaleFactor());
	}
}
